CKEDITOR.dialog.add('pixilinks', function (editor) {
    return {
        title: 'Choisir un article interne',
        minWidth: 400,
        minHeight: 100,

        contents: [
            {
                id: 'info-tab',
                label: 'Basic Settings',
                elements: [
                    // UI elements of the first tab will be defined here.
                    {
                        type: 'text',
                        id: 'link',
                        label: 'Lien interne',
                        validate: CKEDITOR.dialog.validate.notEmpty("Champ Lien interne ne doit pas être vide."),
                        onLoad: function () {
                            var link_id = this.getDialog().getContentElement( 'info-tab', 'link_id' );
                            $("#" + this.getInputElement().getAttribute("id")).autocomplete({
                                source: function (request, response) {
                                    $.ajax({
                                        url: "/posts/autocomp",
                                        dataType: "jsonp",
                                        data: {
                                            term: request.term
                                        },
                                        success: function (data) {
                                            response(data);
                                        },
                                        error: function (xhr, status, error) {
                                            var errorMessage = xhr.status + ': ' + xhr.statusText
                                            console.log('Error - ' + errorMessage);
                                        }
                                    });
                                },
                                focus: function (event, ui) {
                                    $(this).val(ui.item.label);
                                    return false;
                                },
                                select: function (event, ui) {
                                    $("#" + link_id.getInputElement().getAttribute("id")).val(ui.item.value);
                                    return false;
                                }
                            });

                        },
                        setup: function( element ) {
                            this.enable();

                            this.setValue( element.getText() );
                            // Keep inner text so that it can be compared in commit function. By obtaining value from getData()
                            // we get value stripped from new line chars which is important when comparing the value later on.
                            /*initialLinkText = this.getValue();*/
                        },

                        commit: function( element ) {
                            element.setText( this.getValue() );
                        }
                    },
                    {
                        type: 'text',
                        id: 'link_id',
                        hidden: true,
                        setup: function (element) {
                            this.setValue(element.getAttribute("href"));
                        },
                        commit: function (element) {
                            element.setAttribute("href", this.getValue());
                        }
                    }
                ],
            },
        ],
        onShow: function () {
            var selection = editor.getSelection();
            var element = selection.getStartElement();

            if (element)
                element = element.getAscendant('a', true);

            if (!element || element.getName() != 'link_id') {
                element = editor.document.createElement('a');
                this.insertMode = true;
            } else
                this.insertMode = false;

            this.element = element;
            if (!this.insertMode)
                this.setupContent(this.element);
        },
        onOk: function () {
            var dialog = this,
                link = dialog.element;

            dialog.commitContent(link);

            if (dialog.insertMode)
                editor.insertElement(link);
        }
    };
});
